<?php
// توابع ارسال پیام و آموزش تلگرام

require_once __DIR__ . '/../conf/config.php';

define('API_URL', 'https://api.telegram.org/bot' . BOT_TOKEN . '/');

function sendMessage($chat_id, $text, $reply_markup = null) {
    $data = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    if($reply_markup) $data['reply_markup'] = json_encode($reply_markup);
    $result = file_get_contents(API_URL . "sendMessage?" . http_build_query($data));
    $json = json_decode($result, true);
    if(isset($json['ok']) && $json['ok'] && isset($json['result']['message_id'])) {
        return $json['result']['message_id'];
    }
    return false;
}
function editMessage($chat_id, $message_id, $text, $reply_markup = null) {
    $data = [
        'chat_id' => $chat_id,
        'message_id' => $message_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    if($reply_markup) $data['reply_markup'] = json_encode($reply_markup);
    // استفاده از http_build_query با ENCODING_QUERY برای جلوگیری از تبدیل & به &amp;
    $query = http_build_query($data, '', '&', PHP_QUERY_RFC3986);
    file_get_contents(API_URL . "editMessageText?" . $query);
}
function sendPhoto($chat_id, $file_id, $caption = null, $reply_markup = null) {
    $data = ['chat_id' => $chat_id, 'photo' => $file_id];
    if($caption) $data['caption'] = $caption;
    if($reply_markup) $data['reply_markup'] = json_encode($reply_markup);
    file_get_contents(API_URL . "sendPhoto?" . http_build_query($data));
}
function sendVideo($chat_id, $file_id, $caption = null) {
    $data = ['chat_id' => $chat_id, 'video' => $file_id];
    if($caption) $data['caption'] = $caption;
    file_get_contents(API_URL . "sendVideo?" . http_build_query($data));
}
function sendVoice($chat_id, $file_id) {
    $data = ['chat_id' => $chat_id, 'voice' => $file_id];
    file_get_contents(API_URL . "sendVoice?" . http_build_query($data));
}
function sendDocument($chat_id, $file_id, $caption = null) {
    $data = ['chat_id' => $chat_id, 'document' => $file_id];
    if($caption) $data['caption'] = $caption;
    file_get_contents(API_URL . "sendDocument?" . http_build_query($data));
}
function sendTrainingMessage($chat_id, $msg) {
    switch($msg['message_type']) {
        case 'text': sendMessage($chat_id, $msg['message_content']); break;
        case 'photo': sendPhoto($chat_id, $msg['message_content'], $msg['caption']); break;
        case 'video': sendVideo($chat_id, $msg['message_content'], $msg['caption']); break;
        case 'voice': sendVoice($chat_id, $msg['message_content']); break;
        case 'file': sendDocument($chat_id, $msg['message_content'], $msg['caption']); break;
    }
} 