<?php
// تنظیمات امنیتی - غیرفعال کردن نمایش خطاها در production
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
ini_set('log_errors', 1);
error_reporting(E_ALL);
require_once __DIR__ . '/../conf/config.php';
require_once __DIR__ . '/db.php';

define('API_URL', 'https://api.telegram.org/bot' . BOT_TOKEN . '/');

// دریافت داده POST
$content = file_get_contents("php://input");
$order = json_decode($content, true);
if(!$order || !isset($order['id'])) die('no order');

// آماده‌سازی اطلاعات سفارش
$order_id = $order['id'];
$date = $order['date_created'] ?? '-';
$products = [];
foreach($order['line_items'] as $item) {
    $products[] = $item['name'];
}
$products_str = implode('، ', $products);
$total = $order['total'] ?? '-';
$status_map = [
    'processing' => 'در حال انجام',
    'completed' => 'تکمیل‌شده',
    'cancelled' => 'لغو شده',
    'refunded' => 'مسترد شده',
    'pending' => 'در انتظار پرداخت'
];
$status_fa = $status_map[$order['status']] ?? $order['status'];
$name = ($order['billing']['first_name'] ?? '') . ' ' . ($order['billing']['last_name'] ?? '');
$email = $order['billing']['email'] ?? '-';
$phone = $order['billing']['phone'] ?? '-';

// دکمه‌های وضعیت با تیک
$statuses = [
    'processing' => 'در حال انجام',
    'completed' => 'تکمیل‌شده',
    'cancelled' => 'لغو شده',
    'refunded' => 'مسترد شده',
    'pending' => 'در انتظار پرداخت'
];
$status_buttons = [];
foreach ($statuses as $key => $val) {
    $tick = ($order['status'] == $key) ? '✅ ' : '';
    $status_buttons[] = ['text' => $tick . $val, 'callback_data' => "admin_orderstatus_{$order_id}_{$key}"];
}

$text = "🔔 سفارش جدید ثبت شد!\n";
$text .= "شماره سفارش: #{$order_id}\n";
$text .= "تاریخ: {$date}\n";
$text .= "محصول(ها): {$products_str}\n";
$text .= "قیمت: {$total} تومان\n";
$text .= "وضعیت: {$status_fa}\n";
$text .= "نام خریدار: {$name}\n";
$text .= "ایمیل: {$email}\n";
$text .= "تلفن: {$phone}";

$keyboard = [
    'keyboard' => [
        [ ['text'=>'✏️ ارسال یادداشت برای کاربر'], ['text'=>'✏️ فقط برای مدیر'] ],
        array_map(function($btn){ return [['text'=>$btn['text']]]; }, $status_buttons),
        [ ['text'=>'🔎 جزئیات سفارش'] ]
    ],
    'resize_keyboard' => true,
    'one_time_keyboard' => true
];

function sendMessage($chat_id, $text, $reply_markup = null) {
    $data = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    if($reply_markup) $data['reply_markup'] = json_encode($reply_markup);
    file_get_contents(API_URL . "sendMessage?" . http_build_query($data));
}
// ارسال به ادمین‌ها
$stmt = dbQuery("SELECT telegram_id FROM admins");
while($admin = $stmt->fetch()) {
    sendMessage($admin['telegram_id'], $text, $keyboard);
}

// ارسال پیام سفارش جدید به کاربر (در صورت وجود)
function normalizeMobile($mobile) {
    $mobile = trim($mobile);
    $mobile = str_replace([' ', '-', '(', ')'], '', $mobile);
    if(preg_match('/^(\+98|0098|098|98)/', $mobile)) $mobile = preg_replace('/^(\+98|0098|098|98)/', '0', $mobile);
    if(preg_match('/^9\d{9}$/', $mobile)) $mobile = '0' . $mobile;
    $mobile = preg_replace('/[^0-9]/', '', $mobile);
    if(strlen($mobile) != 11 || strpos($mobile, '09') !== 0) return $mobile;
    return $mobile;
}
$phone_normal = normalizeMobile($phone);
if($phone_normal && strlen($phone_normal) === 11 && strpos($phone_normal, '09') === 0) {
    $stmt = dbQuery("SELECT telegram_id FROM users WHERE mobile = ?", [$phone_normal]);
    if($row = $stmt->fetch()) {
        // بررسی وجود لایسنس برای این سفارش
        $license_sent = false;
        foreach($order['line_items'] as $item) {
            $product_id = $item['product_id'] ?? null;
            $variation_id = $item['variation_id'] ?? 0;
            if($product_id && $variation_id) {
                $stmt_lic = dbQuery("SELECT license_key FROM licenses WHERE product_id = ? AND variation_id = ? AND assigned_to_order = ? AND assigned_to_user = ?", [$product_id, $variation_id, $order_id, $phone_normal]);
                if($stmt_lic->fetch()) {
                    $license_sent = true;
                    break;
                }
            }
        }
        
        if($license_sent) {
            // اگر لایسنس ارسال شده، پیام مناسب با دکمه لایسنس
            sendMessage($row['telegram_id'], "🎉 سفارش شما با موفقیت ثبت شد!\nشماره سفارش: #{$order_id}\nمحصول: {$products_str}", [
                'inline_keyboard' => [
                    [['text' => '🔑 دریافت دوباره لایسنس', 'callback_data' => 'user_get_license_' . $order_id]],
                    [['text' => '🎓 دریافت آموزش سفارش #' . $order_id, 'callback_data' => 'my_order_training_' . $order_id]]
                ]
            ]);
        } else {
            // اگر لایسنس ارسال نشده، پیام منتظر تایید
            sendMessage($row['telegram_id'], "🎉 سفارش شما با موفقیت ثبت شد!\nشماره سفارش: #{$order_id}\nمحصول: {$products_str}\nمنتظر تایید و ارسال لایسنس توسط ادمین باشید.\n✅ آموزش را می‌توانید با دکمه زیر دریافت کنید.", [
                'inline_keyboard' => [
                    [['text' => '🎓 دریافت آموزش سفارش #' . $order_id, 'callback_data' => 'my_order_training_' . $order_id]]
                ]
            ]);
        }
    }
}
echo 'ok'; 