<?php
/**
 * فایل تست برای بررسی اینکه آیا webhook درست کار می‌کند
 */

// فعال کردن نمایش خطاها برای تست
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "🔍 تست Webhook\n\n";

// بررسی اینکه آیا فایل‌های لازم وجود دارند
$files_to_check = [
    __DIR__ . '/../conf/config.php',
    __DIR__ . '/db.php',
    __DIR__ . '/message_utils.php',
    __DIR__ . '/user_order_utils.php',
    __DIR__ . '/product_utils.php',
    __DIR__ . '/repeat_purchase_discount_utils.php',
    __DIR__ . '/main.php'
];

echo "📁 بررسی فایل‌ها:\n";
foreach ($files_to_check as $file) {
    if (file_exists($file)) {
        $perms = substr(sprintf('%o', fileperms($file)), -4);
        echo "✅ {$file} (Permission: {$perms})\n";
    } else {
        echo "❌ {$file} - فایل یافت نشد!\n";
    }
}

// تست require
echo "\n📦 تست require فایل‌ها:\n";
try {
    require_once __DIR__ . '/../conf/config.php';
    echo "✅ conf/config.php\n";
    
    require_once __DIR__ . '/db.php';
    echo "✅ db.php\n";
    
    // تست اتصال به دیتابیس
    try {
        $pdo = getDbConnection();
        echo "✅ اتصال به دیتابیس برقرار است\n";
    } catch (Exception $e) {
        echo "❌ خطا در اتصال به دیتابیس: " . $e->getMessage() . "\n";
    }
    
    require_once __DIR__ . '/message_utils.php';
    echo "✅ message_utils.php\n";
    
    require_once __DIR__ . '/user_order_utils.php';
    echo "✅ user_order_utils.php\n";
    
    require_once __DIR__ . '/product_utils.php';
    echo "✅ product_utils.php\n";
    
    require_once __DIR__ . '/repeat_purchase_discount_utils.php';
    echo "✅ repeat_purchase_discount_utils.php\n";
    
} catch (Exception $e) {
    echo "❌ خطا در require: " . $e->getMessage() . "\n";
    echo "📍 فایل: " . $e->getFile() . "\n";
    echo "📍 خط: " . $e->getLine() . "\n";
}

// تست دریافت ورودی
echo "\n📥 تست دریافت ورودی:\n";
$content = file_get_contents("php://input");
if ($content) {
    echo "✅ ورودی دریافت شد (" . strlen($content) . " بایت)\n";
    $update = json_decode($content, true);
    if ($update) {
        echo "✅ JSON معتبر است\n";
        if (isset($update['message']['text'])) {
            echo "📝 متن پیام: " . $update['message']['text'] . "\n";
        }
    } else {
        echo "⚠️ JSON نامعتبر: " . json_last_error_msg() . "\n";
    }
} else {
    echo "⚠️ هیچ ورودی دریافت نشد (این طبیعی است اگر از مرورگر باز کنید)\n";
}

// بررسی permission پوشه
echo "\n📂 بررسی Permission پوشه:\n";
$dir = __DIR__;
$perms = substr(sprintf('%o', fileperms($dir)), -4);
echo "📁 پوشه فعلی: {$dir}\n";
echo "🔐 Permission: {$perms}\n";

if ($perms == '0711' || $perms == '711') {
    echo "✅ Permission پوشه درست است (711)\n";
} else {
    echo "⚠️ Permission پوشه: {$perms} (توصیه می‌شود 711 یا 755)\n";
}

// بررسی permission فایل‌ها
echo "\n📄 بررسی Permission فایل‌ها:\n";
$php_files = glob(__DIR__ . '/*.php');
foreach (array_slice($php_files, 0, 5) as $file) {
    $perms = substr(sprintf('%o', fileperms($file)), -4);
    $name = basename($file);
    echo "📄 {$name}: {$perms}\n";
    if ($perms == '0600' || $perms == '600') {
        echo "   ⚠️ Permission 600 خیلی محدود است. توصیه می‌شود 644 یا 755 باشد.\n";
    }
}

echo "\n✅ تست کامل شد!\n";

