# راهنمای انتقال فایل‌ها به ساختار جدید

## ساختار جدید

```
public_html/
├── conf/                    # فایل‌های حساس (خارج از دسترسی وب)
│   ├── config.php          # فایل تنظیمات (رمزها و API keys)
│   └── .htaccess           # محافظت کامل از پوشه conf
│
└── gctelbot/               # فایل‌های اصلی ربات
    ├── main.php
    ├── db.php
    ├── message_utils.php
    ├── user_order_utils.php
    ├── product_utils.php
    ├── repeat_purchase_discount_utils.php
    ├── webhook_order_status.php
    ├── new_order.php
    ├── remind_mobile.php
    ├── normalize_users.php
    ├── update_cache.php
    ├── .htaccess
    ├── products_cache.json
    ├── product_vars_cache_*.json
    └── products_variations_log.json
```

## مراحل انتقال

### مرحله 1: ایجاد پوشه conf

```bash
cd ~/public_html
mkdir -p conf
chmod 755 conf
```

### مرحله 2: انتقال فایل config.php

```bash
# انتقال فایل config.php از gctelbot به conf
mv ~/public_html/gctelbot/config.php ~/public_html/conf/config.php

# تنظیم مجوزهای امنیتی
chmod 600 ~/public_html/conf/config.php
```

### مرحله 3: ایجاد فایل .htaccess در پوشه conf

فایل `.htaccess` در پوشه `conf/` به صورت خودکار ایجاد شده است. مطمئن شوید که این فایل وجود دارد:

```bash
ls -la ~/public_html/conf/.htaccess
```

### مرحله 4: بررسی فایل‌های به‌روزرسانی شده

تمام فایل‌های PHP در پوشه `gctelbot/` به‌روزرسانی شده‌اند و از مسیر جدید `../conf/config.php` استفاده می‌کنند.

### مرحله 5: تست عملکرد

1. بررسی کنید که ربات به درستی کار می‌کند
2. بررسی کنید که اتصال به دیتابیس برقرار است
3. بررسی کنید که API ووکامرس کار می‌کند

## فایل‌هایی که باید منتقل شوند

### به پوشه `public_html/conf/`:
- ✅ `config.php` (فایل اصلی با اطلاعات حساس)

### در پوشه `public_html/gctelbot/` باقی می‌مانند:
- ✅ تمام فایل‌های PHP دیگر
- ✅ فایل‌های JSON (cache)
- ✅ فایل `.htaccess` (برای محافظت از فایل‌های gctelbot)

## تغییرات انجام شده در کد

### 1. به‌روزرسانی مسیرهای require_once

همه فایل‌ها از `require_once 'config.php'` به `require_once __DIR__ . '/../conf/config.php'` تغییر یافته‌اند.

**فایل‌های به‌روزرسانی شده:**
- `db.php`
- `main.php`
- `message_utils.php`
- `user_order_utils.php`
- `product_utils.php`
- `repeat_purchase_discount_utils.php`
- `webhook_order_status.php`
- `new_order.php`
- `remind_mobile.php`
- `normalize_users.php`
- `update_cache.php`

### 2. به‌روزرسانی مسیرهای فایل‌های cache

مسیرهای هاردکد شده در `user_order_utils.php` به استفاده از `__DIR__` تغییر یافته‌اند:
- `products_cache.json` → `__DIR__ . '/products_cache.json'`
- `product_vars_cache_{id}.json` → `__DIR__ . "/product_vars_cache_{$product_id}.json"`
- `products_variations_log.json` → `__DIR__ . "/products_variations_log.json"`

### 3. به‌روزرسانی .htaccess

قوانین محافظت از `config.php` از `.htaccess` در پوشه `gctelbot/` حذف شده است (چون دیگر در آنجا نیست).

## امنیت

### پوشه conf
- پوشه `conf/` با `.htaccess` محافظت می‌شود و دسترسی به تمام فایل‌های داخل آن مسدود است
- فایل `config.php` با مجوز `600` محافظت می‌شود (فقط مالک می‌تواند بخواند/بنویسد)

### پوشه gctelbot
- فایل `.htaccess` در پوشه `gctelbot/` همچنان فعال است و از فایل‌های حساس محافظت می‌کند
- فقط فایل‌های PHP اصلی (main.php, new_order.php, etc.) قابل دسترسی هستند

## نکات مهم

1. **پشتیبان‌گیری**: قبل از انتقال، حتماً از تمام فایل‌ها پشتیبان بگیرید
2. **مجوزها**: مطمئن شوید که مجوزهای فایل‌ها به درستی تنظیم شده‌اند
3. **تست**: پس از انتقال، تمام عملکردهای ربات را تست کنید
4. **بررسی لاگ‌ها**: در صورت بروز مشکل، لاگ‌های PHP را بررسی کنید

## رفع مشکلات احتمالی

### خطای "config.php not found"
- مطمئن شوید که فایل `config.php` در `public_html/conf/` وجود دارد
- مسیر `../conf/config.php` از پوشه `gctelbot/` باید به `conf/` اشاره کند

### خطای دسترسی به دیتابیس
- بررسی کنید که اطلاعات دیتابیس در `config.php` صحیح است
- بررسی کنید که فایل `config.php` قابل خواندن است (chmod 600)

### خطای 403 Forbidden
- بررسی کنید که `.htaccess` در پوشه `conf/` وجود دارد
- بررسی کنید که Apache mod_rewrite فعال است

## پشتیبانی

در صورت بروز مشکل، لاگ‌های زیر را بررسی کنید:
- `gctelbot/php_error.log`
- `gctelbot/cache_error.log`

