<?php
require_once __DIR__ . '/../conf/config.php';

function getDbConnection() {
    static $pdo;
    if ($pdo) return $pdo;
    $dsn = 'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=utf8mb4';
    try {
        $pdo = new PDO($dsn, DB_USER, DB_PASS, [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]);
        return $pdo;
    } catch (PDOException $e) {
        // لاگ خطا بدون نمایش جزئیات به کاربر
        error_log('Database connection failed: ' . $e->getMessage());
        // نمایش پیام عمومی به جای جزئیات خطا
        if(defined('DEBUG_MODE') && DEBUG_MODE) {
            die('Database connection failed: ' . $e->getMessage());
        } else {
            die('خطا در اتصال به پایگاه داده. لطفاً با پشتیبانی تماس بگیرید.');
        }
    }
}

function dbQuery($sql, $params = []) {
    $pdo = getDbConnection();
    
    // استفاده از prepared statements برای جلوگیری از SQL Injection
    // تمام پارامترها باید از طریق $params ارسال شوند، نه در خود SQL
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    return $stmt;
}

// کدهای غیرضروری حذف شدند برای امنیت بیشتر 