<?php
require_once __DIR__ . '/db.php';

// تابع نرمال‌سازی شماره موبایل (مطابق main.php)
function normalizeMobile($mobile) {
    $mobile = trim($mobile);
    $mobile = str_replace([' ', '-', '(', ')'], '', $mobile);
    if(preg_match('/^(\+98|0098|098|98)/', $mobile)) $mobile = preg_replace('/^(\+98|0098|098|98)/', '0', $mobile);
    if(preg_match('/^9\d{9}$/', $mobile)) $mobile = '0' . $mobile;
    $mobile = preg_replace('/[^0-9]/', '', $mobile);
    if(strlen($mobile) != 11 || strpos($mobile, '09') !== 0) return $mobile;
    return $mobile;
}

// دریافت همه کاربران
$stmt = dbQuery("SELECT telegram_id, mobile FROM users");
while($row = $stmt->fetch()) {
    $old = $row['mobile'];
    $new = normalizeMobile($old);
    if($old !== $new) {
        dbQuery("UPDATE users SET mobile = ? WHERE telegram_id = ?", [$new, $row['telegram_id']]);
        echo "شماره کاربر {$row['telegram_id']} از {$old} به {$new} تغییر یافت.\n";
    }
}
echo "تمام شماره‌ها نرمال شد.\n"; 